// Created by inigo quilez - iq/2014
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

float2 R:TARGETSIZE;

cbuffer cbPerDraw:register( b0 )
{
float4x4 tVP:VIEWPROJECTION;
float4x4 tW:WORLD;
float time;
};

float2 hash( float2 p )
{
    p = float2( dot(p,float2(2127.1,81.17)), dot(p,float2(1269.5,283.37)) );
	return frac(sin(p)*43758.5453);
}

float noise( in float2 p )
{
    float2 i = floor( p );
    float2 f = frac( p );
	
	float2 u = f*f*(3.0-2.0*f);

    float n = lerp( lerp( dot( -1.0+2.0*hash( i + float2(0.0,0.0) ), f - float2(0.0,0.0) ), 
                          dot( -1.0+2.0*hash( i + float2(1.0,0.0) ), f - float2(1.0,0.0) ), u.x),
                    lerp( dot( -1.0+2.0*hash( i + float2(0.0,1.0) ), f - float2(0.0,1.0) ), 
                          dot( -1.0+2.0*hash( i + float2(1.0,1.0) ), f - float2(1.0,1.0) ), u.x), u.y);
	return 0.5 + 0.5*n;
}

float fbm( in float2 x )
{
	float m = 0.0;
	float2 p = 6.0*x;

	float w = 0.5;
	float s = 1.0;
	for( int i=0; i<8; i++ )
    {
		float n = noise( p*s );
		m += w*n;

        p.y -= 1.25*(-1.0+2.0*n) - 0.1*time*w; // warp
		
		w *= 0.5;
		s *= 2.0;

	}
	
    return m;	
}

struct VS_IN
{
	float4 PosO:POSITION;
	float4 TexCd:TEXCOORD0;

};

struct vs2ps
{
    float4 PosWVP:SV_POSITION;
    float4 TexCd:TEXCOORD0;
};

vs2ps VS(VS_IN input)
{
    vs2ps output;
    output.PosWVP = mul(input.PosO,tW); 
    output.TexCd = input.TexCd;
    return output;
}
float4 PS(vs2ps In) : SV_Target
{
     float2 p = In.TexCd.xy;

    // pattern	
	float n = fbm( p );

    // normal	
	float2 e = float2(0.03,0.0);
	float3 nor = normalize( float3( fbm(p-e.xy)-fbm(p+e.xy), 2.0*e.x, fbm(p-e.yx)-fbm(p+e.yx) ) );

    // color
	float c = pow(n,4.0)*6.0;		
	float3 col = 0.5 + 0.5*cos( 5.0 + n*12.0 + float3(0.8,0.4,0.0) );
    col *= 0.4 + 0.6*c;
	
    // light	
	float3 lig = normalize( float3(1.0,0.2,1.0) );
	col *= float3(0.6,0.7,0.8) + 1.0*float3(1.0,0.7,0.5)*clamp( 0.3 + 0.7*dot(nor,lig), 0.0, 1.0 );
    col += 1.5*float3(1.0,0.5,0.0)*pow(1.0-nor.y,2.0)*c;	

    // postpro
	col = sqrt(col)-0.15;
    col *= sqrt(1.0-0.5*abs(p.x-0.5));	
	
   return float4( col, 1.0 );
}


technique10 WarpingProcedural
{
	pass P0
	{
		SetVertexShader( CompileShader(vs_4_0,VS()));
		SetPixelShader(CompileShader(ps_4_0,PS()));
	}
}



